﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class GlucoseDataTable : DataTable
    {
        public GlucoseDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("GLUCOSE_LEVEL", typeof(int)));
            this.Columns.Add(new DataColumn("DATE", typeof(string)));
            this.Columns.Add(new DataColumn("TIME", typeof(string)));
        }

        public GlucoseDataRow this[int index]
        {
            get
            {
                return (GlucoseDataRow)Rows[index];
            }
        }

        public void Add(GlucoseDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(GlucoseDataRow row)
        {
            this.Rows.Remove(row);
        }

        public GlucoseDataRow GetNewRow()
        {
            GlucoseDataRow row = (GlucoseDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(GlucoseDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new GlucoseDataRow(builder);
        }

        public IEnumerator<GlucoseDataRow> GetEnumerator()
        {
            List<GlucoseDataRow> rows = new List<GlucoseDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((GlucoseDataRow)this.Rows[i]);
            }

            return rows.GetEnumerator();
        }
    }
}
